#include <sys/types.h>
#include <sys/param.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <locale.h>
#include <unistd.h>

#include <netinet/in.h>
#include <sys/socket.h>
#include <net/if.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>

#ifdef USE_EMUSIG
void (*sigset())();
#endif

typedef struct _URL {
	struct _URL *next;              /* linked list */
	struct _URL *parentURL;         /* where HREF= was defined */

	char *fullName;                 /* full URL name */
#ifdef DEBUG
	char *shortName;                /* the name from HREF="..." string */
#endif

	u_short port;                   /* TCP/IP connection port */
	char *hostName;                 /* parsed */
	char *urlName;                  /* parsed */

	char *ctype;                    /* HTTP contents type */

	long int counter;		/* reference counter */
	unsigned long serial;           /* serial number in the list */
	int retcode;			/* connection HTTP code */
	long int level;
	long int trys;			/* network trys */
	long int hrefs;			/* the number of HREF='s */
	short hops;			/* recursive hop (far distance) */

	size_t size;                    /* document size */
	size_t declared_size;           /* HTTP declared document size */

	int flags;			/* job procession flags */

/* ------------------------------------------------ */
/* Eraseable flags */
#define UNTOUCHED       0x00000000
#define PROCESSED       0x00000001

#define CONNECTED       0x00000002
#define FAILED          0x00000004
#define SKIPPED         0x00000008
#define UNKNOWN         0x00000010
#define IGNORED         0x00000020
#define WRONGSIZE       0x00000040
#define HTTPERROR       0x00000080
#define RETRY           0x00000100
#define EXISTS          0x00000200
#define REGET           0x00000400
#define RANDOMSIZE      0x00000800
#define NOTPARSED       0x00001000
#define REDIRECTED      0x00002000

#define MASK            0x0000ffff

#define isUntouched(ptr)        (((ptr)->flags & MASK) == UNTOUCHED)
#define setUntouched(ptr)       {       \
	(ptr)->flags &= ~MASK;                 \
	(ptr)->flags |=  MASK & UNTOUCHED;     \
				}
/* Once set - stay forever flags */
#define DONTPARSE       0x00010000
#define THISONLY        0x00020000
#define FORCED          0x00040000
#define REDIRECTEDTO    0x00080000
#define BASEHREF        0x00100000
#define USEPOST		0x00200000

#define NoFlags         0x00000000
/* ------------------------------------------------ */

	struct in_addr *address_list;           /* IP addresses */

	char *location;                 /* redirected URL (code 302 Found) */
	char *post_data;

} URL;

typedef struct _list {
	URL *head, *tail;
	URL *currentURL;
} List;

/* length of static char[] */
#define STRLEN(s)       (sizeof(s)-1)

typedef struct _WORD {
	char *s;
	int slen;
} WORD;

extern List     workList;
extern u_short  HTTPPORT, basePort, proxy_port;
extern char    *HOME;
extern int      recflag;
extern int      debugflag;
extern int      appendflag;
extern int      weak_appendflag;
extern int      reget_appendflag;
extern int      retryflag;
extern int      keepflag;
extern int      picsonlyflag;
extern int      skiprootdir;
extern int      skipparentdir;
extern int      skipparents;
extern int      skipcgiflag;
extern int      proxyflag;
extern int      underflag;
extern char    *underdir;
extern int      nowarnflag;
extern int	anysizeflag;
extern int	anysizeflag_save;
extern int      redirsaveflag;
extern int      ill_urls_flag;
extern int      verbose;
extern int      keepalive;
extern int      hostflag;
extern int      xxdecodflag;
extern int      xxencodflag;
extern int      reassignportsflag;
extern int	slashflag;
extern int	noreport;
extern FILE    *fplog, *fpreport;
extern char    *mylogdir;
extern char     logname[];
extern char     tmpname[];
extern int      TIMEOUT;
extern int      error_counter;
extern char    *loadfile;
extern char    *authstring;
extern int      nullflag;
extern char    *proxy_host;
extern int	maxhops;
extern int	nobreak_amp;
extern int	nobreak_spaces;
extern int	stripOnSemicolon;
extern int	break_on_spaces;
extern int	trimURLspaces;
extern int	use_gzip;
extern int	relaxtime;
extern int	text_as_HTML;
extern int	headOnly;
extern int	cutRedirs;
extern int	nohup_flag;
extern int	humanlike;
extern int	redimages;
extern int	limit404, count404;
extern int	restart_intr;
extern int	substitute_amp;
extern int	parse_arrays;
extern int	power_tab_archive;
extern int	drop_quot;
extern int	skip_this;

extern int MAXTRYS;
extern int RETRY_IMMEDIATELY;

extern unsigned long urlcounter;

extern URL     *basehref;

#undef FALSE
#undef TRUE

typedef enum { HEADER, BODY } State;
typedef enum { FALSE=0, TRUE=1 } Bool;
typedef enum {
	HTTP_OK=200,
	HTTP_MOVED=301,
	HTTP_FOUND=302,
	HTTP_FORBIDDEN=403,
	HTTP_NOTFOUND=404,
	HTTP_REQTIMEOUT=408,
	HTTP_SERVERBAD=500,
	HTTP_GATEWAYBAD=502,
	HTTP_SERVICEBAD=503,
	HTTP_GATEWAYTIMEOUT=504,
	HTTP_UNKNOWNBAD=508,	/* traffic limit reached */
} HttpCode;

#define INDEXNAME       "index.html"
#define SPOOLDIR        "WWWcache"
#define NOSIZE          ((size_t)(-1))

#define isdir(st)       ((st.st_mode & S_IFMT) == S_IFDIR)
#define isreg(st)       ((st.st_mode & S_IFMT) == S_IFREG)

#define NAME_DIR        ".DIR"
#define NAME_OLD        ".OLD"
#define NAME_REDIR      ".REDIRECT"

typedef struct _Item {
	char *text;
	int   length;
	int   flags;
	Bool  is_a_dir;

	struct _Item *next;
} Item;

/* main.c */
void die(int nsig);
void dieabort(int nsig);
void init(char *prog, char *logdir, int AC, char **AV);
void logItStart(char **avorig);
void logItFinish(char **avorig);
int main(int ac, char *av[]);
void lowercase(unsigned char *s);
void lowercaseHostName(unsigned char *s);
char *strend(char *s);
char *strlast(char *s);
char *strspl(char *s1, ...);
char *basename(char *s);
int lengthVector(char **vect);
char **saveVector(char **vect);
Bool makepath(char *path, Bool redirected, char *newname);
void myperror(char *msg);
Bool compareFiles(char *n1, char *n2);
char *currentDate();
Bool strsuffix(char *str, char *suff);
Bool isimage(URL *ptr);
/* mainloop.c */
URL *newURL(List *list, URL *parent, char *href, char *fullName);
Bool isFullURL(char *href, char **rest /*OUT*/);
Bool isFullURL3(char *href);
Bool isNotHTTP(char *href);
Bool isLegalHost(List *list,  URL *ptr);
Bool isParent(URL *current,   URL *ptr);
Bool skipExisting(List *list, URL *ptr);
char *computeFullName(List *list, URL *currentURL, char *href, int *addflags);
void parseName(URL *ptr);
URL *addURL(List *list, char *href, int addflags);
void addFirst(List *list, char *href);
void loadURLFile(List *list, char *filename);
void processURL(List *list, URL *ptr);
void mainLoop(List *list);
int countRemaining(List *list, int *to_retry);
void retryNotReceived(List *list);
Bool computeFileName(char *outname, char *hostname, char *urlname, u_short port, char *postfix);
int processDocument(List *list, URL *urlptr, char *filename);
void reportList(List *list);
void reportLongList(List *list,  FILE *fp);
void reportShortList(List *list, FILE *fp);
void addSkipItem(char *s, int flag);
void addMatchPattern(char *s, int set);
void addNMatchPattern(char *s, int set);
void addAllowedHost(char *s);
void addDeniedHost(char *s);
Bool hostAllowed(char *);
Bool hostDenied(char *);
Bool checkIfToSkip(URL *urlptr);
void deXXname(char *href);
void enXXname(char *href);
/* canonize.c */
void CUTOFF(char *u);
char *canonize(char *currentdir, char *href, int *addflags);
/* net.c */
void initNet(void);
int callHost(List *list, URL *urlptr);
struct in_addr *saveAddresses(struct hostent *hp);
char **copyAddresses(struct hostent *hp);
void saveAddrList(URL *ptr, struct hostent *hp);
Bool oneOfAddresses(char *hostname, struct in_addr *addresses);
/* parser.c */
Bool isBreakChar(unsigned c);
void resetParser(void);
void rememberURL(List *list, char *href);
void checkChar(List *list, unsigned c);
void onlyHref();
void initWORDs();
struct hostent *MY_gethostbyname(char *name);
struct hostent *FIXED_gethostbyname(char *name);
void printHostStats(FILE *fp);

