/*
 * Copyright (C) Sergey P. Derevyago, 2000-2004.
 *
 * Permission to copy, use, modify, sell and distribute this software is granted
 * provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied warranty, and
 * with no claim as to its suitability for any purpose.
 *
 */

#include <ostream> 

/**     c_form,    */
namespace c_form_private {

 typedef std::ios_base::fmtflags fmtflags;
 typedef std::ostream ostream;
 typedef std::ios_base ios;

 /**
  *     .
  */
 class Formatter {
       /**    */
       fmtflags newFlags;
       /**  */
       int width;
       /**  */
       int prec;
       /** - */
       char fill;
       /**   */
       fmtflags oldFlags;

  public:
       /**
        *  ,   .
        */
       Formatter(const char* form, int arg1, int arg2);

       /**
        *      , 
        * .
        */
       void setFormatting(ostream& os);

       /**
        *   ,   
        * setFormatting().
        */
       void restoreFormatting(ostream& os);
 };

 /**
  *  .
  */
 template <class T>
 class Helper {
       /**   */
       const T& val;
       /**    */
       mutable Formatter fmtr;
       
  public:
       /**
        *     .
        */
       Helper(const T& val_, const char* form, int arg1, int arg2) :
         val(val_), fmtr(form, arg1, arg2) {}

       /**
        *          .
        */
       void putTo(ostream& os) const;
 };

 template <class T>
 void Helper<T>::putTo(ostream& os) const
 {
  fmtr.setFormatting(os);
  os<<val;
  fmtr.restoreFormatting(os);
 }

 /**
  *     Helper  .
  */
 template <class T>
 inline ostream& operator<<(ostream& os, const Helper<T>& h)
 {
  h.putTo(os);
  return os;
 }
}

/**
 * -,    , 
 *      ostream.  
 *      .
 * @param val   
 * @param form  : [-|0] [|*] [.(|*)] [e|f|g|o|x]
 * @param arg1  ,    .
 * @param arg2  ,  .
 * @throws std::invalid_argument    form 
 *         .
 */
template <class T>
inline c_form_private::Helper<T> c_form(const T& val, const char* form,
  int arg1=0, int arg2=0)
{
 return c_form_private::Helper<T>(val, form, arg1, arg2);
}

